/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import java.util.logging.Level;
import org.adempiere.base.IAddressValidationFactory;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.adempiere.model.IAddressValidation;
import org.compiere.util.CLogger;

public class DefaultAddressValidationFactory
implements IAddressValidationFactory {
    private static final CLogger s_log = CLogger.getCLogger(DefaultAddressValidationFactory.class);

    @Override
    public IAddressValidation newAddressValidationInstance(String className) {
        IAddressValidation myProcessor = EquinoxExtensionLocator.instance().locate(IAddressValidation.class, className, null).getExtension();
        if (myProcessor == null) {
            try {
                Class<?> ppClass = Class.forName(className);
                if (ppClass != null) {
                    myProcessor = (IAddressValidation)ppClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Error e1) {
                s_log.log(Level.SEVERE, className + " - Error=" + e1.getMessage());
                return null;
            }
            catch (Exception e2) {
                s_log.log(Level.SEVERE, className, e2);
                return null;
            }
        }
        if (myProcessor == null) {
            s_log.log(Level.SEVERE, "Not found in extension registry and classpath");
            return null;
        }
        return myProcessor;
    }
}

